<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\QR_Code\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_qr_code_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-qr-code-js', AUTOMATORWP_QR_CODE_URL . 'assets/js/automatorwp-qr-code' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_QR_CODE_VER, true );

}
add_action( 'admin_init', 'automatorwp_qr_code_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_qr_code_admin_enqueue_scripts( $hook ) {

    // Scripts
    wp_localize_script( 'automatorwp-qr-code-js', 'automatorwp_qr_code', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-qr-code-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_qr_code_admin_enqueue_scripts', 100 );